IF EXISTS ( SELECT * 
            FROM   sysobjects 
            WHERE  id = object_id(N'dbo.CF_SCA_ValidarEvento') 
                   and type = 'FN')
BEGIN
    DROP FUNCTION dbo.CF_SCA_ValidarEvento
END
GO

CREATE FUNCTION [dbo].[CF_SCA_ValidarEvento](@pId_Cliente INT, @pId_Acceso SMALLINT, @pFecha DATETIME)
RETURNS SMALLINT
AS
BEGIN
DECLARE @Id_Lista_Precio		SMALLINT

SET @Id_Lista_Precio = 0

SET @Id_Lista_Precio =	ISNULL((SELECT CB.Id_Lista
								FROM Cbtes_Items CI, Cbtes CB, Cbtes_Tipos CT, Clientes CL
								WHERE 
								CI.Id_Trans = CB.Id_Trans
								AND CT.Id_Tipo_Cbte = CB.Id_Tipo_Cbte
								AND (ISNULL(CT.Compromete_Factura, 0) = 1 OR ISNULL(CT.Compromete_Remitos, 0) = 1 OR ISNULL(CT.Compromete_Pedido, 0) = 1) --21/10/2021 Se agrego compromete Pedido
								AND CB.Id_Estado_Cbte IN (4, 2)
								AND CI.Id_Cliente = CL.Id_Cliente 
								AND CB.Id_Lista IN (SELECT Id_Lista_Precio FROM CD_Accesos_Eventos WHERE Id_Acceso = @pId_Acceso)
								AND CI.Fecha_QA <= @pFecha			--06/10/2021 Se reemplazo el < por <=
								AND CI.Fecha_Venc >= @pFecha
								AND CL.Id_Cliente = @pId_Cliente)
								, 0)

RETURN ISNULL(@Id_Lista_Precio, 0)
END
